// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.io;

import ORG.oclc.oai.harvester.verb.Record;
import java.io.IOException;
import org.xml.sax.SAXException;
import java.net.MalformedURLException;
import java.util.List;
import ORG.oclc.oai.harvester.verb.OAIError;
import ORG.oclc.oai.harvester.verb.ListRecords;
import java.util.Iterator;
import java.net.URL;

public class OAIReader
{
    private URL baseURL;
    private String resumptionToken;
    private Iterator records;
    
    public OAIReader(final URL baseURL, final String from, final String until, final String set, final String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this.resumptionToken = null;
        this.records = null;
        this.baseURL = baseURL;
        final ListRecords listRecords = new ListRecords(baseURL, from, until, set, metadataPrefix);
        if (listRecords != null) {
            final List errors = listRecords.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.records = listRecords.iterator();
            this.resumptionToken = listRecords.getResumptionToken();
        }
    }
    
    public Record readNext() throws MalformedURLException, SAXException, IOException, OAIError {
        while (this.records != null && !this.records.hasNext()) {
            if (this.resumptionToken == null) {
                return null;
            }
            final ListRecords listRecords = new ListRecords(this.baseURL, this.resumptionToken);
            if (listRecords == null) {
                return null;
            }
            final List errors = listRecords.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.records = listRecords.iterator();
            this.resumptionToken = listRecords.getResumptionToken();
        }
        if (this.records == null) {
            return null;
        }
        return this.records.next();
    }
    
    public void close() {
    }
}
